package editor;

import game.CustomImageDataII;
import game.IntRect;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.image.ImageObserver;
import java.io.BufferedWriter;

public class RadioScreenObject extends ScreenObject implements CloneableScreenObject {
	
	
	private static CustomImageDataII radioImage;
	
	
	private IntRect clickRect;
	
	private boolean isSelected;
	
	private RadioScreenPaletteObject paletteObject;
	
	
	public static synchronized CustomImageDataII getRadioImage(ImageObserver io) {
		
		if(radioImage == null) {
			
			try {
				radioImage = new CustomImageDataII("/images/radio.GIF", Color.white, io);
			} catch(Exception e) {
//				e.printStackTrace();
			}
			
		}
		
		return radioImage;
	}
	
	
	
	@Override
	public void draw(Graphics g) {
		
		Color origCol = g.getColor();
		
		
		if(radioImage != null)
			radioImage.drawObjectFromUpperLeftCorner(g, clickRect.getMinX(), clickRect.getMinY());
		
		if(paletteObject != null && paletteObject.getCaption() != null && paletteObject.getCaptionColor() != null) {
			Font origFont = g.getFont();
			Font newFont = new Font(origFont.getName(), Font.BOLD, 18);
			g.setFont(newFont);
			g.setColor(paletteObject.getCaptionColor());
			g.drawString(paletteObject.getCaption(), clickRect.getMinX() + 4, clickRect.getMaxY() - 10);
			g.setFont(origFont);
			
		}
		
		
		g.setColor(origCol);
		
		
		if(isSelected)
			drawSelectionOverObject(g);
		
	}

	@Override
	public IntRect getClickRect() {
		return clickRect;
	}

	@Override
	public void setClickRect(IntRect newRect) {
		clickRect = newRect;
	}

	@Override
	public void setSelected(boolean is) {
		isSelected = is;
	}

	@Override
	public boolean isSelected() {
		return isSelected;
	}
	
	
	
	
	public RadioScreenObject(ImageObserver io, IntRect theClickRect, RadioScreenPaletteObject thePaletteObject) {
		
		
		if(radioImage == null) {
			getRadioImage(io);
		}
		
		clickRect = theClickRect;
		
		paletteObject = thePaletteObject;
	}



	
	public PaletteObject getPaletteObject() {
		return paletteObject;
	}
	
	
	public String getCaption() {
		if(paletteObject == null)
			return null;
		else
			return paletteObject.getCaption();
	}
	
	
	public void writeOutToFile(BufferedWriter out) throws Exception {
		
		out.write("radio:");
		out.newLine();
		
		Point centerPoint = clickRect.getCenter();
		
		out.write("x:");
		out.write(Integer.toString(centerPoint.x));
		out.newLine();
		
		out.write("y:");
		out.write(Integer.toString(centerPoint.y));
		out.newLine();
		
		out.write("sound:");
		out.write(paletteObject.getWaveFile());
		out.newLine();
		
		if(paletteObject.getCaption() != null && paletteObject.getCaption().length() > 0 && paletteObject.getCaptionColor() != null) {
			out.write("caption:");
			out.write(paletteObject.getCaption());
			out.newLine();
			
			out.write("captionColor:");
			out.write(CustomAnimationPanel.convertColorToString(paletteObject.getCaptionColor()));
			out.newLine();
		}
		
		if(paletteObject.getCaption() != null && paletteObject.getCaptionColor() != null) {
			out.write("editorCaption:" + paletteObject.getCaption());
			out.newLine();
			out.write("editorColor:" + CustomAnimationPanel.convertColorToString(paletteObject.getCaptionColor()));
			out.newLine();
		}
		
		
		out.write("/radio");
		out.newLine();
		
		out.newLine();
		
	}
	
	
	public RadioScreenObject clone(ImageObserver io) {
		
		RadioScreenObject returnValue = new RadioScreenObject(io, this.clickRect.clone(), this.paletteObject);
		
		return returnValue;
		
		
	}
	
	
	@Override
	public int getLayer() {
		
		return 6;
	}
}
